function mainCategoryListFocus(event) {
	var sCatEdit = document.getElementById('sCatEdit');	
	var sCatDelete = document.getElementById('sCatDelete');
	sCatEdit.removeAttribute("disabled");
	sCatDelete.removeAttribute("disabled");
	document.getElementById('reminderFox_cats_moveUp').removeAttribute("disabled");
	document.getElementById('reminderFox_cats_moveDown').removeAttribute("disabled");
}

function readCurrentCategories() {
	/* delete all cat-items categories, then insert from prefs */
	
	// -- 'current' cat-items --
	var catList = document.getElementById('userCatBox');
	var count = catList.childNodes.length;
	
	while ( count-- ) {
		if (catList.childNodes[count].getAttribute( "value")  != 3) {
			catList.removeChild(catList.childNodes[count])
		}
	}
	var catArray = getUserCategories(); 
	var count2 = catArray.length

	while ( count2 -- ) {
		 var m1 = document.createElement("listitem");
		 // apply parameters & insert before node 0
		 m1.setAttribute("label", reminderFox_trim(catArray[count2]));
		 if ( catList.childNodes.length == 0 ) {
		 	 catList.insertBefore(m1,null);
		 }
		 else {
			 catList.insertBefore(m1,catList.childNodes[0]);
		 }
	}
}

function readDefaultCategories() {
/* ------------------------------------with open XUL
            read the 'user' and 'main' cats, write to textboxes
*/
	/*read both categories 'user' and 'main' from prefs */
	var rmCategoriesStandard = rmReadCategories2prefs();
	
	// --  'main' cat-items --
	var catList = document.getElementById('mainCatBox');
	var count = catList.childNodes.length;
	
	while ( count-- ) {
		if (catList.childNodes[count].getAttribute( "value")  != 3) {
			catList.removeChild(catList.childNodes[count])
		}
	}
	var catArray = categoriesArray(rmCategoriesStandard);
	var count2 = catArray.length

	while ( count2 -- ) {
		 var m1 = document.createElement("listitem");
		 // apply parameters & insert before node 0
		 m1.setAttribute("label", reminderFox_trim(catArray[count2]));
		 if ( catList.childNodes.length == 0 ) {
		 	 catList.insertBefore(m1,null);
		 }
		 else {
			catList.insertBefore(m1,catList.childNodes[0]);
		 }
	}
}

function saveCategoriesGroupsAndClose() {
	saveCategoriesGroups();
	window.close();
}

function saveCurrentCategoriesAndClose() {
	window.close();
}

function saveCategoriesGroups(mode) {	
	var catMainList = document.getElementById('mainCatBox');
	var count = catMainList.childNodes.length;
	
	var rmCategoriesStandard = "";
	for (var i=0; i<count; i++) {
		if (catMainList.childNodes[i].label != "") { 
		rmCategoriesStandard += escCommas(catMainList.childNodes[i].label) +",";
		}
	}
	if (mode != null) {	
		var catArray = categoriesArray(rmCategoriesStandard); 
		if (mode == 'up') rmCategoriesStandard = catArray.sort().join(',');
		if (mode == 'down') rmCategoriesStandard = catArray.sort().reverse().join(',');
	}

	rmWriteCategories2prefs(categoriesNoDup(rmCategoriesStandard));
	
	return rmCategoriesStandard;
}


function moveCategoryToDefaultList () {
/* --------------------------------------move seletecd catItem from 
										     'user' to 'main' group
*/
	var catCurList = document.getElementById('userCatBox');
	var selectedItems = catCurList.selectedItems;
	
	for ( var i = selectedItems.length - 1; i >= 0; i-- ) {
		var selCatItem = selectedItems[i];
		var moveItem = selCatItem.label;
		catCurList.removeChild(selCatItem);

		var catMainList = window.opener.document.getElementById('mainCatBox');
		var m1 = window.opener.document.createElement("listitem");
		 m1.setAttribute("label", moveItem);
		catMainList.insertBefore(m1,catMainList.childNodes[0]);
	}
	
	window.opener.saveCategoriesGroups();

}

function selectedCatItemDelete() {
/* ------------------------------------------------   from 'main' catList
*/
	var catMainList = document.getElementById('mainCatBox');
	var selCatItem = catMainList.currentIndex;
	
	if ((selCatItem > -1 )) {
		catMainList.removeChild(catMainList.childNodes[selCatItem]);
	}
}

var addOrEdit;

function go4Category(event) {
/* --------------------------------------------------
*/
	var editCat;
	addOrEdit = event.id;
	
	if (addOrEdit == "sCatEdit") {
		var catCurList = document.getElementById('mainCatBox');
		var selCatItem = catCurList.currentIndex;
		
		if (selCatItem == -1) {return;}  /* no item selecetd */
		
		var editCat = catCurList.childNodes[selCatItem].label
	} 
	else {   /*  sCatAdd */
		editCat="";
	}
	
	var callOptions = { eventID: addOrEdit, currentItem: editCat };
	window.openDialog("chrome://reminderfox/content/categories/addCategory.xul",
			"reminderFox-editAdd-categories", "chrome,resizable,modal", callOptions );
}

function showAllCurrentCategories() { 
	window.openDialog("chrome://reminderfox/content/categories/currentCategories.xul",
		"reminderFox-editAdd-categories", "chrome,resizable,modal" );
}

function returnCategory(item) {
/* --------------------------------------------------
	'item' has been send from Add/Edit Mask 
	Have to 
	 -- check for duplicates in 'standard'-cat-item list
	 -- escape commas
	 Will new/added item push to top of list
*/
	if (addOrEdit == "sCatEdit") {
		selectedCatItemDelete();
	}
	saveCategoriesGroups();
	addOrEdit = "";
	rmWriteCategories2prefs(categoriesNoDup(escCommas(item) + ',' + rmReadCategories2prefs()));
	readDefaultCategories();
}

function catMoveUp() {
	var  categoryList= document.getElementById("mainCatBox");
	var index = categoryList.selectedIndex;;
	
	if ( index > 0 ) {
		var child = categoryList.childNodes[index-1];
		var moved = categoryList.removeChild(categoryList.childNodes[index]);
		categoryList.insertBefore( moved, child );
		categoryList.selectedIndex = index -1;
	}
}

function catMoveDown() {
	var  categoryList= document.getElementById("mainCatBox");
	var index = categoryList.selectedIndex;;
	
	if ( index ==  categoryList.childNodes.length - 2 ) {
		var moved = categoryList.removeChild(categoryList.childNodes[index]);
		categoryList.appendChild(moved);
		 categoryList.selectedIndex =  categoryList.childNodes.length - 1;;

	}
	else 	if ( index < categoryList.childNodes.length - 1 ) {
			var child = categoryList.childNodes[index];
			var moved = categoryList.removeChild(categoryList.childNodes[index+1]);
			categoryList.insertBefore( moved, child );
					 categoryList.selectedIndex = index + 1;
	}
}


/**
 * Categories sorting for 'Default' 
 * @param mode		= 'up' or 'down'
 * @return
 */
function catSort(mode) {
	if (mode == null) mode = "";
	saveCategoriesGroups(mode);
	readDefaultCategories();
}
